﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/neptune/model/DescribeDBInstancesResult.h>

#include <utility>

using namespace Aws::Neptune::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils::Logging;
using namespace Aws::Utils;
using namespace Aws;

DescribeDBInstancesResult::DescribeDBInstancesResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) { *this = result; }

DescribeDBInstancesResult& DescribeDBInstancesResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode rootNode = xmlDocument.GetRootElement();
  XmlNode resultNode = rootNode;
  if (!rootNode.IsNull() && (rootNode.GetName() != "DescribeDBInstancesResult")) {
    resultNode = rootNode.FirstChild("DescribeDBInstancesResult");
  }

  if (!resultNode.IsNull()) {
    XmlNode markerNode = resultNode.FirstChild("Marker");
    if (!markerNode.IsNull()) {
      m_marker = Aws::Utils::Xml::DecodeEscapedXmlText(markerNode.GetText());
      m_markerHasBeenSet = true;
    }
    XmlNode dBInstancesNode = resultNode.FirstChild("DBInstances");
    if (!dBInstancesNode.IsNull()) {
      XmlNode dBInstancesMember = dBInstancesNode.FirstChild("DBInstance");
      m_dBInstancesHasBeenSet = !dBInstancesMember.IsNull();
      while (!dBInstancesMember.IsNull()) {
        m_dBInstances.push_back(dBInstancesMember);
        dBInstancesMember = dBInstancesMember.NextNode("DBInstance");
      }

      m_dBInstancesHasBeenSet = true;
    }
  }

  if (!rootNode.IsNull()) {
    XmlNode responseMetadataNode = rootNode.FirstChild("ResponseMetadata");
    m_responseMetadata = responseMetadataNode;
    m_responseMetadataHasBeenSet = true;
    AWS_LOGSTREAM_DEBUG("Aws::Neptune::Model::DescribeDBInstancesResult", "x-amzn-request-id: " << m_responseMetadata.GetRequestId());
  }
  return *this;
}
