﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/neptune/model/PromoteReadReplicaDBClusterRequest.h>

using namespace Aws::Neptune::Model;
using namespace Aws::Utils;

Aws::String PromoteReadReplicaDBClusterRequest::SerializePayload() const {
  Aws::StringStream ss;
  ss << "Action=PromoteReadReplicaDBCluster&";
  if (m_dBClusterIdentifierHasBeenSet) {
    ss << "DBClusterIdentifier=" << StringUtils::URLEncode(m_dBClusterIdentifier.c_str()) << "&";
  }

  ss << "Version=2014-10-31";
  return ss.str();
}

void PromoteReadReplicaDBClusterRequest::DumpBodyToUrl(Aws::Http::URI& uri) const { uri.SetQueryString(SerializePayload()); }
