﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/neptune/model/RemoveSourceIdentifierFromSubscriptionRequest.h>

using namespace Aws::Neptune::Model;
using namespace Aws::Utils;

Aws::String RemoveSourceIdentifierFromSubscriptionRequest::SerializePayload() const {
  Aws::StringStream ss;
  ss << "Action=RemoveSourceIdentifierFromSubscription&";
  if (m_subscriptionNameHasBeenSet) {
    ss << "SubscriptionName=" << StringUtils::URLEncode(m_subscriptionName.c_str()) << "&";
  }

  if (m_sourceIdentifierHasBeenSet) {
    ss << "SourceIdentifier=" << StringUtils::URLEncode(m_sourceIdentifier.c_str()) << "&";
  }

  ss << "Version=2014-10-31";
  return ss.str();
}

void RemoveSourceIdentifierFromSubscriptionRequest::DumpBodyToUrl(Aws::Http::URI& uri) const { uri.SetQueryString(SerializePayload()); }
