﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/networkflowmonitor/model/TargetIdentifier.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace NetworkFlowMonitor {
namespace Model {

TargetIdentifier::TargetIdentifier(JsonView jsonValue) { *this = jsonValue; }

TargetIdentifier& TargetIdentifier::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("targetId")) {
    m_targetId = jsonValue.GetObject("targetId");
    m_targetIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("targetType")) {
    m_targetType = TargetTypeMapper::GetTargetTypeForName(jsonValue.GetString("targetType"));
    m_targetTypeHasBeenSet = true;
  }
  return *this;
}

JsonValue TargetIdentifier::Jsonize() const {
  JsonValue payload;

  if (m_targetIdHasBeenSet) {
    payload.WithObject("targetId", m_targetId.Jsonize());
  }

  if (m_targetTypeHasBeenSet) {
    payload.WithString("targetType", TargetTypeMapper::GetNameForTargetType(m_targetType));
  }

  return payload;
}

}  // namespace Model
}  // namespace NetworkFlowMonitor
}  // namespace Aws
