﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/payment-cryptography/model/GetKeyRequest.h>

#include <utility>

using namespace Aws::PaymentCryptography::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetKeyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_keyIdentifierHasBeenSet) {
    payload.WithString("KeyIdentifier", m_keyIdentifier);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetKeyRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "PaymentCryptographyControlPlane.GetKey"));
  return headers;
}
