﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/qbusiness/model/AttachmentStatus.h>

using namespace Aws::Utils;

namespace Aws {
namespace QBusiness {
namespace Model {
namespace AttachmentStatusMapper {

static const int FAILED_HASH = HashingUtils::HashString("FAILED");
static const int SUCCESS_HASH = HashingUtils::HashString("SUCCESS");

AttachmentStatus GetAttachmentStatusForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == FAILED_HASH) {
    return AttachmentStatus::FAILED;
  } else if (hashCode == SUCCESS_HASH) {
    return AttachmentStatus::SUCCESS;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<AttachmentStatus>(hashCode);
  }

  return AttachmentStatus::NOT_SET;
}

Aws::String GetNameForAttachmentStatus(AttachmentStatus enumValue) {
  switch (enumValue) {
    case AttachmentStatus::NOT_SET:
      return {};
    case AttachmentStatus::FAILED:
      return "FAILED";
    case AttachmentStatus::SUCCESS:
      return "SUCCESS";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace AttachmentStatusMapper
}  // namespace Model
}  // namespace QBusiness
}  // namespace Aws
