﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/qbusiness/model/CreatePluginRequest.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreatePluginRequest::SerializePayload() const {
  JsonValue payload;

  if (m_displayNameHasBeenSet) {
    payload.WithString("displayName", m_displayName);
  }

  if (m_typeHasBeenSet) {
    payload.WithString("type", PluginTypeMapper::GetNameForPluginType(m_type));
  }

  if (m_authConfigurationHasBeenSet) {
    payload.WithObject("authConfiguration", m_authConfiguration.Jsonize());
  }

  if (m_serverUrlHasBeenSet) {
    payload.WithString("serverUrl", m_serverUrl);
  }

  if (m_customPluginConfigurationHasBeenSet) {
    payload.WithObject("customPluginConfiguration", m_customPluginConfiguration.Jsonize());
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("tags", std::move(tagsJsonList));
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("clientToken", m_clientToken);
  }

  return payload.View().WriteReadable();
}
