﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/qbusiness/model/PutGroupRequest.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String PutGroupRequest::SerializePayload() const {
  JsonValue payload;

  if (m_groupNameHasBeenSet) {
    payload.WithString("groupName", m_groupName);
  }

  if (m_dataSourceIdHasBeenSet) {
    payload.WithString("dataSourceId", m_dataSourceId);
  }

  if (m_typeHasBeenSet) {
    payload.WithString("type", MembershipTypeMapper::GetNameForMembershipType(m_type));
  }

  if (m_groupMembersHasBeenSet) {
    payload.WithObject("groupMembers", m_groupMembers.Jsonize());
  }

  if (m_roleArnHasBeenSet) {
    payload.WithString("roleArn", m_roleArn);
  }

  return payload.View().WriteReadable();
}
