﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/qbusiness/model/ResponseConfigurationType.h>

using namespace Aws::Utils;

namespace Aws {
namespace QBusiness {
namespace Model {
namespace ResponseConfigurationTypeMapper {

static const int ALL_HASH = HashingUtils::HashString("ALL");

ResponseConfigurationType GetResponseConfigurationTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ALL_HASH) {
    return ResponseConfigurationType::ALL;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<ResponseConfigurationType>(hashCode);
  }

  return ResponseConfigurationType::NOT_SET;
}

Aws::String GetNameForResponseConfigurationType(ResponseConfigurationType enumValue) {
  switch (enumValue) {
    case ResponseConfigurationType::NOT_SET:
      return {};
    case ResponseConfigurationType::ALL:
      return "ALL";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace ResponseConfigurationTypeMapper
}  // namespace Model
}  // namespace QBusiness
}  // namespace Aws
