﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/qbusiness/model/SearchRelevantContentRequest.h>

#include <utility>

using namespace Aws::QBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String SearchRelevantContentRequest::SerializePayload() const {
  JsonValue payload;

  if (m_queryTextHasBeenSet) {
    payload.WithString("queryText", m_queryText);
  }

  if (m_contentSourceHasBeenSet) {
    payload.WithObject("contentSource", m_contentSource.Jsonize());
  }

  if (m_attributeFilterHasBeenSet) {
    payload.WithObject("attributeFilter", m_attributeFilter.Jsonize());
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("maxResults", m_maxResults);
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("nextToken", m_nextToken);
  }

  return payload.View().WriteReadable();
}
