﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/qbusiness/model/UserAlias.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace QBusiness {
namespace Model {

UserAlias::UserAlias(JsonView jsonValue) { *this = jsonValue; }

UserAlias& UserAlias::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("indexId")) {
    m_indexId = jsonValue.GetString("indexId");
    m_indexIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("dataSourceId")) {
    m_dataSourceId = jsonValue.GetString("dataSourceId");
    m_dataSourceIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("userId")) {
    m_userId = jsonValue.GetString("userId");
    m_userIdHasBeenSet = true;
  }
  return *this;
}

JsonValue UserAlias::Jsonize() const {
  JsonValue payload;

  if (m_indexIdHasBeenSet) {
    payload.WithString("indexId", m_indexId);
  }

  if (m_dataSourceIdHasBeenSet) {
    payload.WithString("dataSourceId", m_dataSourceId);
  }

  if (m_userIdHasBeenSet) {
    payload.WithString("userId", m_userId);
  }

  return payload;
}

}  // namespace Model
}  // namespace QBusiness
}  // namespace Aws
