﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/rds/model/DeleteDBSubnetGroupRequest.h>

using namespace Aws::RDS::Model;
using namespace Aws::Utils;

Aws::String DeleteDBSubnetGroupRequest::SerializePayload() const {
  Aws::StringStream ss;
  ss << "Action=DeleteDBSubnetGroup&";
  if (m_dBSubnetGroupNameHasBeenSet) {
    ss << "DBSubnetGroupName=" << StringUtils::URLEncode(m_dBSubnetGroupName.c_str()) << "&";
  }

  ss << "Version=2014-10-31";
  return ss.str();
}

void DeleteDBSubnetGroupRequest::DumpBodyToUrl(Aws::Http::URI& uri) const { uri.SetQueryString(SerializePayload()); }
