﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/rds/model/DescribeOptionGroupOptionsResult.h>

#include <utility>

using namespace Aws::RDS::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils::Logging;
using namespace Aws::Utils;
using namespace Aws;

DescribeOptionGroupOptionsResult::DescribeOptionGroupOptionsResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  *this = result;
}

DescribeOptionGroupOptionsResult& DescribeOptionGroupOptionsResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode rootNode = xmlDocument.GetRootElement();
  XmlNode resultNode = rootNode;
  if (!rootNode.IsNull() && (rootNode.GetName() != "DescribeOptionGroupOptionsResult")) {
    resultNode = rootNode.FirstChild("DescribeOptionGroupOptionsResult");
  }

  if (!resultNode.IsNull()) {
    XmlNode optionGroupOptionsNode = resultNode.FirstChild("OptionGroupOptions");
    if (!optionGroupOptionsNode.IsNull()) {
      XmlNode optionGroupOptionsMember = optionGroupOptionsNode.FirstChild("OptionGroupOption");
      m_optionGroupOptionsHasBeenSet = !optionGroupOptionsMember.IsNull();
      while (!optionGroupOptionsMember.IsNull()) {
        m_optionGroupOptions.push_back(optionGroupOptionsMember);
        optionGroupOptionsMember = optionGroupOptionsMember.NextNode("OptionGroupOption");
      }

      m_optionGroupOptionsHasBeenSet = true;
    }
    XmlNode markerNode = resultNode.FirstChild("Marker");
    if (!markerNode.IsNull()) {
      m_marker = Aws::Utils::Xml::DecodeEscapedXmlText(markerNode.GetText());
      m_markerHasBeenSet = true;
    }
  }

  if (!rootNode.IsNull()) {
    XmlNode responseMetadataNode = rootNode.FirstChild("ResponseMetadata");
    m_responseMetadata = responseMetadataNode;
    m_responseMetadataHasBeenSet = true;
    AWS_LOGSTREAM_DEBUG("Aws::RDS::Model::DescribeOptionGroupOptionsResult", "x-amzn-request-id: " << m_responseMetadata.GetRequestId());
  }
  return *this;
}
