﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/rds/model/DescribeReservedDBInstancesRequest.h>

using namespace Aws::RDS::Model;
using namespace Aws::Utils;

Aws::String DescribeReservedDBInstancesRequest::SerializePayload() const {
  Aws::StringStream ss;
  ss << "Action=DescribeReservedDBInstances&";
  if (m_reservedDBInstanceIdHasBeenSet) {
    ss << "ReservedDBInstanceId=" << StringUtils::URLEncode(m_reservedDBInstanceId.c_str()) << "&";
  }

  if (m_reservedDBInstancesOfferingIdHasBeenSet) {
    ss << "ReservedDBInstancesOfferingId=" << StringUtils::URLEncode(m_reservedDBInstancesOfferingId.c_str()) << "&";
  }

  if (m_dBInstanceClassHasBeenSet) {
    ss << "DBInstanceClass=" << StringUtils::URLEncode(m_dBInstanceClass.c_str()) << "&";
  }

  if (m_durationHasBeenSet) {
    ss << "Duration=" << StringUtils::URLEncode(m_duration.c_str()) << "&";
  }

  if (m_productDescriptionHasBeenSet) {
    ss << "ProductDescription=" << StringUtils::URLEncode(m_productDescription.c_str()) << "&";
  }

  if (m_offeringTypeHasBeenSet) {
    ss << "OfferingType=" << StringUtils::URLEncode(m_offeringType.c_str()) << "&";
  }

  if (m_multiAZHasBeenSet) {
    ss << "MultiAZ=" << std::boolalpha << m_multiAZ << "&";
  }

  if (m_leaseIdHasBeenSet) {
    ss << "LeaseId=" << StringUtils::URLEncode(m_leaseId.c_str()) << "&";
  }

  if (m_filtersHasBeenSet) {
    if (m_filters.empty()) {
      ss << "Filters=&";
    } else {
      unsigned filtersCount = 1;
      for (auto& item : m_filters) {
        item.OutputToStream(ss, "Filters.Filter.", filtersCount, "");
        filtersCount++;
      }
    }
  }

  if (m_maxRecordsHasBeenSet) {
    ss << "MaxRecords=" << m_maxRecords << "&";
  }

  if (m_markerHasBeenSet) {
    ss << "Marker=" << StringUtils::URLEncode(m_marker.c_str()) << "&";
  }

  ss << "Version=2014-10-31";
  return ss.str();
}

void DescribeReservedDBInstancesRequest::DumpBodyToUrl(Aws::Http::URI& uri) const { uri.SetQueryString(SerializePayload()); }
