﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/rds/model/ModifyDBClusterRequest.h>

using namespace Aws::RDS::Model;
using namespace Aws::Utils;

Aws::String ModifyDBClusterRequest::SerializePayload() const {
  Aws::StringStream ss;
  ss << "Action=ModifyDBCluster&";
  if (m_dBClusterIdentifierHasBeenSet) {
    ss << "DBClusterIdentifier=" << StringUtils::URLEncode(m_dBClusterIdentifier.c_str()) << "&";
  }

  if (m_newDBClusterIdentifierHasBeenSet) {
    ss << "NewDBClusterIdentifier=" << StringUtils::URLEncode(m_newDBClusterIdentifier.c_str()) << "&";
  }

  if (m_applyImmediatelyHasBeenSet) {
    ss << "ApplyImmediately=" << std::boolalpha << m_applyImmediately << "&";
  }

  if (m_backupRetentionPeriodHasBeenSet) {
    ss << "BackupRetentionPeriod=" << m_backupRetentionPeriod << "&";
  }

  if (m_dBClusterParameterGroupNameHasBeenSet) {
    ss << "DBClusterParameterGroupName=" << StringUtils::URLEncode(m_dBClusterParameterGroupName.c_str()) << "&";
  }

  if (m_vpcSecurityGroupIdsHasBeenSet) {
    if (m_vpcSecurityGroupIds.empty()) {
      ss << "VpcSecurityGroupIds=&";
    } else {
      unsigned vpcSecurityGroupIdsCount = 1;
      for (auto& item : m_vpcSecurityGroupIds) {
        ss << "VpcSecurityGroupIds.VpcSecurityGroupId." << vpcSecurityGroupIdsCount << "=" << StringUtils::URLEncode(item.c_str()) << "&";
        vpcSecurityGroupIdsCount++;
      }
    }
  }

  if (m_portHasBeenSet) {
    ss << "Port=" << m_port << "&";
  }

  if (m_masterUserPasswordHasBeenSet) {
    ss << "MasterUserPassword=" << StringUtils::URLEncode(m_masterUserPassword.c_str()) << "&";
  }

  if (m_optionGroupNameHasBeenSet) {
    ss << "OptionGroupName=" << StringUtils::URLEncode(m_optionGroupName.c_str()) << "&";
  }

  if (m_preferredBackupWindowHasBeenSet) {
    ss << "PreferredBackupWindow=" << StringUtils::URLEncode(m_preferredBackupWindow.c_str()) << "&";
  }

  if (m_preferredMaintenanceWindowHasBeenSet) {
    ss << "PreferredMaintenanceWindow=" << StringUtils::URLEncode(m_preferredMaintenanceWindow.c_str()) << "&";
  }

  if (m_enableIAMDatabaseAuthenticationHasBeenSet) {
    ss << "EnableIAMDatabaseAuthentication=" << std::boolalpha << m_enableIAMDatabaseAuthentication << "&";
  }

  if (m_backtrackWindowHasBeenSet) {
    ss << "BacktrackWindow=" << m_backtrackWindow << "&";
  }

  if (m_cloudwatchLogsExportConfigurationHasBeenSet) {
    m_cloudwatchLogsExportConfiguration.OutputToStream(ss, "CloudwatchLogsExportConfiguration");
  }

  if (m_engineVersionHasBeenSet) {
    ss << "EngineVersion=" << StringUtils::URLEncode(m_engineVersion.c_str()) << "&";
  }

  if (m_allowMajorVersionUpgradeHasBeenSet) {
    ss << "AllowMajorVersionUpgrade=" << std::boolalpha << m_allowMajorVersionUpgrade << "&";
  }

  if (m_dBInstanceParameterGroupNameHasBeenSet) {
    ss << "DBInstanceParameterGroupName=" << StringUtils::URLEncode(m_dBInstanceParameterGroupName.c_str()) << "&";
  }

  if (m_domainHasBeenSet) {
    ss << "Domain=" << StringUtils::URLEncode(m_domain.c_str()) << "&";
  }

  if (m_domainIAMRoleNameHasBeenSet) {
    ss << "DomainIAMRoleName=" << StringUtils::URLEncode(m_domainIAMRoleName.c_str()) << "&";
  }

  if (m_scalingConfigurationHasBeenSet) {
    m_scalingConfiguration.OutputToStream(ss, "ScalingConfiguration");
  }

  if (m_deletionProtectionHasBeenSet) {
    ss << "DeletionProtection=" << std::boolalpha << m_deletionProtection << "&";
  }

  if (m_enableHttpEndpointHasBeenSet) {
    ss << "EnableHttpEndpoint=" << std::boolalpha << m_enableHttpEndpoint << "&";
  }

  if (m_copyTagsToSnapshotHasBeenSet) {
    ss << "CopyTagsToSnapshot=" << std::boolalpha << m_copyTagsToSnapshot << "&";
  }

  if (m_enableGlobalWriteForwardingHasBeenSet) {
    ss << "EnableGlobalWriteForwarding=" << std::boolalpha << m_enableGlobalWriteForwarding << "&";
  }

  if (m_dBClusterInstanceClassHasBeenSet) {
    ss << "DBClusterInstanceClass=" << StringUtils::URLEncode(m_dBClusterInstanceClass.c_str()) << "&";
  }

  if (m_allocatedStorageHasBeenSet) {
    ss << "AllocatedStorage=" << m_allocatedStorage << "&";
  }

  if (m_storageTypeHasBeenSet) {
    ss << "StorageType=" << StringUtils::URLEncode(m_storageType.c_str()) << "&";
  }

  if (m_iopsHasBeenSet) {
    ss << "Iops=" << m_iops << "&";
  }

  if (m_autoMinorVersionUpgradeHasBeenSet) {
    ss << "AutoMinorVersionUpgrade=" << std::boolalpha << m_autoMinorVersionUpgrade << "&";
  }

  if (m_networkTypeHasBeenSet) {
    ss << "NetworkType=" << StringUtils::URLEncode(m_networkType.c_str()) << "&";
  }

  if (m_serverlessV2ScalingConfigurationHasBeenSet) {
    m_serverlessV2ScalingConfiguration.OutputToStream(ss, "ServerlessV2ScalingConfiguration");
  }

  if (m_monitoringIntervalHasBeenSet) {
    ss << "MonitoringInterval=" << m_monitoringInterval << "&";
  }

  if (m_monitoringRoleArnHasBeenSet) {
    ss << "MonitoringRoleArn=" << StringUtils::URLEncode(m_monitoringRoleArn.c_str()) << "&";
  }

  if (m_databaseInsightsModeHasBeenSet) {
    ss << "DatabaseInsightsMode="
       << StringUtils::URLEncode(DatabaseInsightsModeMapper::GetNameForDatabaseInsightsMode(m_databaseInsightsMode)) << "&";
  }

  if (m_enablePerformanceInsightsHasBeenSet) {
    ss << "EnablePerformanceInsights=" << std::boolalpha << m_enablePerformanceInsights << "&";
  }

  if (m_performanceInsightsKMSKeyIdHasBeenSet) {
    ss << "PerformanceInsightsKMSKeyId=" << StringUtils::URLEncode(m_performanceInsightsKMSKeyId.c_str()) << "&";
  }

  if (m_performanceInsightsRetentionPeriodHasBeenSet) {
    ss << "PerformanceInsightsRetentionPeriod=" << m_performanceInsightsRetentionPeriod << "&";
  }

  if (m_manageMasterUserPasswordHasBeenSet) {
    ss << "ManageMasterUserPassword=" << std::boolalpha << m_manageMasterUserPassword << "&";
  }

  if (m_rotateMasterUserPasswordHasBeenSet) {
    ss << "RotateMasterUserPassword=" << std::boolalpha << m_rotateMasterUserPassword << "&";
  }

  if (m_enableLocalWriteForwardingHasBeenSet) {
    ss << "EnableLocalWriteForwarding=" << std::boolalpha << m_enableLocalWriteForwarding << "&";
  }

  if (m_masterUserSecretKmsKeyIdHasBeenSet) {
    ss << "MasterUserSecretKmsKeyId=" << StringUtils::URLEncode(m_masterUserSecretKmsKeyId.c_str()) << "&";
  }

  if (m_engineModeHasBeenSet) {
    ss << "EngineMode=" << StringUtils::URLEncode(m_engineMode.c_str()) << "&";
  }

  if (m_allowEngineModeChangeHasBeenSet) {
    ss << "AllowEngineModeChange=" << std::boolalpha << m_allowEngineModeChange << "&";
  }

  if (m_awsBackupRecoveryPointArnHasBeenSet) {
    ss << "AwsBackupRecoveryPointArn=" << StringUtils::URLEncode(m_awsBackupRecoveryPointArn.c_str()) << "&";
  }

  if (m_enableLimitlessDatabaseHasBeenSet) {
    ss << "EnableLimitlessDatabase=" << std::boolalpha << m_enableLimitlessDatabase << "&";
  }

  if (m_cACertificateIdentifierHasBeenSet) {
    ss << "CACertificateIdentifier=" << StringUtils::URLEncode(m_cACertificateIdentifier.c_str()) << "&";
  }

  if (m_masterUserAuthenticationTypeHasBeenSet) {
    ss << "MasterUserAuthenticationType="
       << StringUtils::URLEncode(MasterUserAuthenticationTypeMapper::GetNameForMasterUserAuthenticationType(m_masterUserAuthenticationType))
       << "&";
  }

  ss << "Version=2014-10-31";
  return ss.str();
}

void ModifyDBClusterRequest::DumpBodyToUrl(Aws::Http::URI& uri) const { uri.SetQueryString(SerializePayload()); }
