﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/rds/model/ModifyDBRecommendationResult.h>

#include <utility>

using namespace Aws::RDS::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils::Logging;
using namespace Aws::Utils;
using namespace Aws;

ModifyDBRecommendationResult::ModifyDBRecommendationResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) { *this = result; }

ModifyDBRecommendationResult& ModifyDBRecommendationResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode rootNode = xmlDocument.GetRootElement();
  XmlNode resultNode = rootNode;
  if (!rootNode.IsNull() && (rootNode.GetName() != "ModifyDBRecommendationResult")) {
    resultNode = rootNode.FirstChild("ModifyDBRecommendationResult");
  }

  if (!resultNode.IsNull()) {
    XmlNode dBRecommendationNode = resultNode.FirstChild("DBRecommendation");
    if (!dBRecommendationNode.IsNull()) {
      m_dBRecommendation = dBRecommendationNode;
      m_dBRecommendationHasBeenSet = true;
    }
  }

  if (!rootNode.IsNull()) {
    XmlNode responseMetadataNode = rootNode.FirstChild("ResponseMetadata");
    m_responseMetadata = responseMetadataNode;
    m_responseMetadataHasBeenSet = true;
    AWS_LOGSTREAM_DEBUG("Aws::RDS::Model::ModifyDBRecommendationResult", "x-amzn-request-id: " << m_responseMetadata.GetRequestId());
  }
  return *this;
}
