﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/Challenge.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Rekognition {
namespace Model {

Challenge::Challenge(JsonView jsonValue) { *this = jsonValue; }

Challenge& Challenge::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Type")) {
    m_type = ChallengeTypeMapper::GetChallengeTypeForName(jsonValue.GetString("Type"));
    m_typeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Version")) {
    m_version = jsonValue.GetString("Version");
    m_versionHasBeenSet = true;
  }
  return *this;
}

JsonValue Challenge::Jsonize() const {
  JsonValue payload;

  if (m_typeHasBeenSet) {
    payload.WithString("Type", ChallengeTypeMapper::GetNameForChallengeType(m_type));
  }

  if (m_versionHasBeenSet) {
    payload.WithString("Version", m_version);
  }

  return payload;
}

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
