﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/FaceDetection.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Rekognition {
namespace Model {

FaceDetection::FaceDetection(JsonView jsonValue) { *this = jsonValue; }

FaceDetection& FaceDetection::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Timestamp")) {
    m_timestamp = jsonValue.GetInt64("Timestamp");
    m_timestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Face")) {
    m_face = jsonValue.GetObject("Face");
    m_faceHasBeenSet = true;
  }
  return *this;
}

JsonValue FaceDetection::Jsonize() const {
  JsonValue payload;

  if (m_timestampHasBeenSet) {
    payload.WithInt64("Timestamp", m_timestamp);
  }

  if (m_faceHasBeenSet) {
    payload.WithObject("Face", m_face.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
