﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/rekognition/model/GetMediaAnalysisJobResult.h>

#include <utility>

using namespace Aws::Rekognition::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetMediaAnalysisJobResult::GetMediaAnalysisJobResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetMediaAnalysisJobResult& GetMediaAnalysisJobResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("JobId")) {
    m_jobId = jsonValue.GetString("JobId");
    m_jobIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("JobName")) {
    m_jobName = jsonValue.GetString("JobName");
    m_jobNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("OperationsConfig")) {
    m_operationsConfig = jsonValue.GetObject("OperationsConfig");
    m_operationsConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Status")) {
    m_status = MediaAnalysisJobStatusMapper::GetMediaAnalysisJobStatusForName(jsonValue.GetString("Status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("FailureDetails")) {
    m_failureDetails = jsonValue.GetObject("FailureDetails");
    m_failureDetailsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreationTimestamp")) {
    m_creationTimestamp = jsonValue.GetDouble("CreationTimestamp");
    m_creationTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CompletionTimestamp")) {
    m_completionTimestamp = jsonValue.GetDouble("CompletionTimestamp");
    m_completionTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Input")) {
    m_input = jsonValue.GetObject("Input");
    m_inputHasBeenSet = true;
  }
  if (jsonValue.ValueExists("OutputConfig")) {
    m_outputConfig = jsonValue.GetObject("OutputConfig");
    m_outputConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("KmsKeyId")) {
    m_kmsKeyId = jsonValue.GetString("KmsKeyId");
    m_kmsKeyIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Results")) {
    m_results = jsonValue.GetObject("Results");
    m_resultsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ManifestSummary")) {
    m_manifestSummary = jsonValue.GetObject("ManifestSummary");
    m_manifestSummaryHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
