﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/rekognition/model/ListDatasetLabelsResult.h>

#include <utility>

using namespace Aws::Rekognition::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListDatasetLabelsResult::ListDatasetLabelsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListDatasetLabelsResult& ListDatasetLabelsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("DatasetLabelDescriptions")) {
    Aws::Utils::Array<JsonView> datasetLabelDescriptionsJsonList = jsonValue.GetArray("DatasetLabelDescriptions");
    for (unsigned datasetLabelDescriptionsIndex = 0; datasetLabelDescriptionsIndex < datasetLabelDescriptionsJsonList.GetLength();
         ++datasetLabelDescriptionsIndex) {
      m_datasetLabelDescriptions.push_back(datasetLabelDescriptionsJsonList[datasetLabelDescriptionsIndex].AsObject());
    }
    m_datasetLabelDescriptionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
