﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/ProjectPolicy.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Rekognition {
namespace Model {

ProjectPolicy::ProjectPolicy(JsonView jsonValue) { *this = jsonValue; }

ProjectPolicy& ProjectPolicy::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("ProjectArn")) {
    m_projectArn = jsonValue.GetString("ProjectArn");
    m_projectArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("PolicyName")) {
    m_policyName = jsonValue.GetString("PolicyName");
    m_policyNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("PolicyRevisionId")) {
    m_policyRevisionId = jsonValue.GetString("PolicyRevisionId");
    m_policyRevisionIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("PolicyDocument")) {
    m_policyDocument = jsonValue.GetString("PolicyDocument");
    m_policyDocumentHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreationTimestamp")) {
    m_creationTimestamp = jsonValue.GetDouble("CreationTimestamp");
    m_creationTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LastUpdatedTimestamp")) {
    m_lastUpdatedTimestamp = jsonValue.GetDouble("LastUpdatedTimestamp");
    m_lastUpdatedTimestampHasBeenSet = true;
  }
  return *this;
}

JsonValue ProjectPolicy::Jsonize() const {
  JsonValue payload;

  if (m_projectArnHasBeenSet) {
    payload.WithString("ProjectArn", m_projectArn);
  }

  if (m_policyNameHasBeenSet) {
    payload.WithString("PolicyName", m_policyName);
  }

  if (m_policyRevisionIdHasBeenSet) {
    payload.WithString("PolicyRevisionId", m_policyRevisionId);
  }

  if (m_policyDocumentHasBeenSet) {
    payload.WithString("PolicyDocument", m_policyDocument);
  }

  if (m_creationTimestampHasBeenSet) {
    payload.WithDouble("CreationTimestamp", m_creationTimestamp.SecondsWithMSPrecision());
  }

  if (m_lastUpdatedTimestampHasBeenSet) {
    payload.WithDouble("LastUpdatedTimestamp", m_lastUpdatedTimestamp.SecondsWithMSPrecision());
  }

  return payload;
}

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
