﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/rekognition/model/ProjectStatus.h>

using namespace Aws::Utils;

namespace Aws {
namespace Rekognition {
namespace Model {
namespace ProjectStatusMapper {

static const int CREATING_HASH = HashingUtils::HashString("CREATING");
static const int CREATED_HASH = HashingUtils::HashString("CREATED");
static const int DELETING_HASH = HashingUtils::HashString("DELETING");

ProjectStatus GetProjectStatusForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == CREATING_HASH) {
    return ProjectStatus::CREATING;
  } else if (hashCode == CREATED_HASH) {
    return ProjectStatus::CREATED;
  } else if (hashCode == DELETING_HASH) {
    return ProjectStatus::DELETING;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<ProjectStatus>(hashCode);
  }

  return ProjectStatus::NOT_SET;
}

Aws::String GetNameForProjectStatus(ProjectStatus enumValue) {
  switch (enumValue) {
    case ProjectStatus::NOT_SET:
      return {};
    case ProjectStatus::CREATING:
      return "CREATING";
    case ProjectStatus::CREATED:
      return "CREATED";
    case ProjectStatus::DELETING:
      return "DELETING";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace ProjectStatusMapper
}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
