﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/SearchedUser.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Rekognition {
namespace Model {

SearchedUser::SearchedUser(JsonView jsonValue) { *this = jsonValue; }

SearchedUser& SearchedUser::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("UserId")) {
    m_userId = jsonValue.GetString("UserId");
    m_userIdHasBeenSet = true;
  }
  return *this;
}

JsonValue SearchedUser::Jsonize() const {
  JsonValue payload;

  if (m_userIdHasBeenSet) {
    payload.WithString("UserId", m_userId);
  }

  return payload;
}

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
