﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/StartContentModerationRequest.h>

#include <utility>

using namespace Aws::Rekognition::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StartContentModerationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_videoHasBeenSet) {
    payload.WithObject("Video", m_video.Jsonize());
  }

  if (m_minConfidenceHasBeenSet) {
    payload.WithDouble("MinConfidence", m_minConfidence);
  }

  if (m_clientRequestTokenHasBeenSet) {
    payload.WithString("ClientRequestToken", m_clientRequestToken);
  }

  if (m_notificationChannelHasBeenSet) {
    payload.WithObject("NotificationChannel", m_notificationChannel.Jsonize());
  }

  if (m_jobTagHasBeenSet) {
    payload.WithString("JobTag", m_jobTag);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection StartContentModerationRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "RekognitionService.StartContentModeration"));
  return headers;
}
