﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/StartTextDetectionRequest.h>

#include <utility>

using namespace Aws::Rekognition::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StartTextDetectionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_videoHasBeenSet) {
    payload.WithObject("Video", m_video.Jsonize());
  }

  if (m_clientRequestTokenHasBeenSet) {
    payload.WithString("ClientRequestToken", m_clientRequestToken);
  }

  if (m_notificationChannelHasBeenSet) {
    payload.WithObject("NotificationChannel", m_notificationChannel.Jsonize());
  }

  if (m_jobTagHasBeenSet) {
    payload.WithString("JobTag", m_jobTag);
  }

  if (m_filtersHasBeenSet) {
    payload.WithObject("Filters", m_filters.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection StartTextDetectionRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "RekognitionService.StartTextDetection"));
  return headers;
}
