﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/Sunglasses.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Rekognition {
namespace Model {

Sunglasses::Sunglasses(JsonView jsonValue) { *this = jsonValue; }

Sunglasses& Sunglasses::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Value")) {
    m_value = jsonValue.GetBool("Value");
    m_valueHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Confidence")) {
    m_confidence = jsonValue.GetDouble("Confidence");
    m_confidenceHasBeenSet = true;
  }
  return *this;
}

JsonValue Sunglasses::Jsonize() const {
  JsonValue payload;

  if (m_valueHasBeenSet) {
    payload.WithBool("Value", m_value);
  }

  if (m_confidenceHasBeenSet) {
    payload.WithDouble("Confidence", m_confidence);
  }

  return payload;
}

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
