﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rekognition/model/UpdateDatasetEntriesRequest.h>

#include <utility>

using namespace Aws::Rekognition::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateDatasetEntriesRequest::SerializePayload() const {
  JsonValue payload;

  if (m_datasetArnHasBeenSet) {
    payload.WithString("DatasetArn", m_datasetArn);
  }

  if (m_changesHasBeenSet) {
    payload.WithObject("Changes", m_changes.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateDatasetEntriesRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "RekognitionService.UpdateDatasetEntries"));
  return headers;
}
