﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/resiliencehub/model/ListAppVersionResourcesResult.h>

#include <utility>

using namespace Aws::ResilienceHub::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListAppVersionResourcesResult::ListAppVersionResourcesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListAppVersionResourcesResult& ListAppVersionResourcesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("physicalResources")) {
    Aws::Utils::Array<JsonView> physicalResourcesJsonList = jsonValue.GetArray("physicalResources");
    for (unsigned physicalResourcesIndex = 0; physicalResourcesIndex < physicalResourcesJsonList.GetLength(); ++physicalResourcesIndex) {
      m_physicalResources.push_back(physicalResourcesJsonList[physicalResourcesIndex].AsObject());
    }
    m_physicalResourcesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("resolutionId")) {
    m_resolutionId = jsonValue.GetString("resolutionId");
    m_resolutionIdHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
