﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/resiliencehub/model/StartAppAssessmentRequest.h>

#include <utility>

using namespace Aws::ResilienceHub::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StartAppAssessmentRequest::SerializePayload() const {
  JsonValue payload;

  if (m_appArnHasBeenSet) {
    payload.WithString("appArn", m_appArn);
  }

  if (m_appVersionHasBeenSet) {
    payload.WithString("appVersion", m_appVersion);
  }

  if (m_assessmentNameHasBeenSet) {
    payload.WithString("assessmentName", m_assessmentName);
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("clientToken", m_clientToken);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("tags", std::move(tagsJsonMap));
  }

  return payload.View().WriteReadable();
}
