﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/resource-explorer-2/model/ResourceProperty.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace ResourceExplorer2 {
namespace Model {

ResourceProperty::ResourceProperty(JsonView jsonValue) { *this = jsonValue; }

ResourceProperty& ResourceProperty::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Name")) {
    m_name = jsonValue.GetString("Name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LastReportedAt")) {
    m_lastReportedAt = jsonValue.GetString("LastReportedAt");
    m_lastReportedAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Data")) {
    m_data = jsonValue.GetObject("Data");
    m_dataHasBeenSet = true;
  }
  return *this;
}

JsonValue ResourceProperty::Jsonize() const {
  JsonValue payload;

  if (m_nameHasBeenSet) {
    payload.WithString("Name", m_name);
  }

  if (m_lastReportedAtHasBeenSet) {
    payload.WithString("LastReportedAt", m_lastReportedAt.ToGmtString(Aws::Utils::DateFormat::ISO_8601));
  }

  if (m_dataHasBeenSet) {
    if (!m_data.View().IsNull()) {
      payload.WithObject("Data", JsonValue(m_data.View()));
    }
  }

  return payload;
}

}  // namespace Model
}  // namespace ResourceExplorer2
}  // namespace Aws
