﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/rolesanywhere/model/ResetNotificationSettingsRequest.h>

#include <utility>

using namespace Aws::RolesAnywhere::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ResetNotificationSettingsRequest::SerializePayload() const {
  JsonValue payload;

  if (m_trustAnchorIdHasBeenSet) {
    payload.WithString("trustAnchorId", m_trustAnchorId);
  }

  if (m_notificationSettingKeysHasBeenSet) {
    Aws::Utils::Array<JsonValue> notificationSettingKeysJsonList(m_notificationSettingKeys.size());
    for (unsigned notificationSettingKeysIndex = 0; notificationSettingKeysIndex < notificationSettingKeysJsonList.GetLength();
         ++notificationSettingKeysIndex) {
      notificationSettingKeysJsonList[notificationSettingKeysIndex].AsObject(
          m_notificationSettingKeys[notificationSettingKeysIndex].Jsonize());
    }
    payload.WithArray("notificationSettingKeys", std::move(notificationSettingKeysJsonList));
  }

  return payload.View().WriteReadable();
}
