﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/route53-recovery-readiness/model/ListRecoveryGroupsResult.h>

#include <utility>

using namespace Aws::Route53RecoveryReadiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRecoveryGroupsResult::ListRecoveryGroupsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListRecoveryGroupsResult& ListRecoveryGroupsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("recoveryGroups")) {
    Aws::Utils::Array<JsonView> recoveryGroupsJsonList = jsonValue.GetArray("recoveryGroups");
    for (unsigned recoveryGroupsIndex = 0; recoveryGroupsIndex < recoveryGroupsJsonList.GetLength(); ++recoveryGroupsIndex) {
      m_recoveryGroups.push_back(recoveryGroupsJsonList[recoveryGroupsIndex].AsObject());
    }
    m_recoveryGroupsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
