﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/s3control/model/LifecycleConfiguration.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws {
namespace S3Control {
namespace Model {

LifecycleConfiguration::LifecycleConfiguration(const XmlNode& xmlNode) { *this = xmlNode; }

LifecycleConfiguration& LifecycleConfiguration::operator=(const XmlNode& xmlNode) {
  XmlNode resultNode = xmlNode;

  if (!resultNode.IsNull()) {
    XmlNode rulesNode = resultNode.FirstChild("Rules");
    if (!rulesNode.IsNull()) {
      XmlNode rulesMember = rulesNode.FirstChild("Rule");
      m_rulesHasBeenSet = !rulesMember.IsNull();
      while (!rulesMember.IsNull()) {
        m_rules.push_back(rulesMember);
        rulesMember = rulesMember.NextNode("Rule");
      }

      m_rulesHasBeenSet = true;
    }
  }

  return *this;
}

void LifecycleConfiguration::AddToNode(XmlNode& parentNode) const {
  Aws::StringStream ss;
  if (m_rulesHasBeenSet) {
    XmlNode rulesParentNode = parentNode.CreateChildElement("Rules");
    for (const auto& item : m_rules) {
      XmlNode rulesNode = rulesParentNode.CreateChildElement("Rule");
      item.AddToNode(rulesNode);
    }
  }
}

}  // namespace Model
}  // namespace S3Control
}  // namespace Aws
