﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/s3control/model/MFADelete.h>

using namespace Aws::Utils;

namespace Aws {
namespace S3Control {
namespace Model {
namespace MFADeleteMapper {

static const int Enabled_HASH = HashingUtils::HashString("Enabled");
static const int Disabled_HASH = HashingUtils::HashString("Disabled");

MFADelete GetMFADeleteForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == Enabled_HASH) {
    return MFADelete::Enabled;
  } else if (hashCode == Disabled_HASH) {
    return MFADelete::Disabled;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<MFADelete>(hashCode);
  }

  return MFADelete::NOT_SET;
}

Aws::String GetNameForMFADelete(MFADelete enumValue) {
  switch (enumValue) {
    case MFADelete::NOT_SET:
      return {};
    case MFADelete::Enabled:
      return "Enabled";
    case MFADelete::Disabled:
      return "Disabled";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace MFADeleteMapper
}  // namespace Model
}  // namespace S3Control
}  // namespace Aws
