﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/s3tables/model/GetTableBucketMaintenanceConfigurationResult.h>

#include <utility>

using namespace Aws::S3Tables::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetTableBucketMaintenanceConfigurationResult::GetTableBucketMaintenanceConfigurationResult(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

GetTableBucketMaintenanceConfigurationResult& GetTableBucketMaintenanceConfigurationResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("tableBucketARN")) {
    m_tableBucketARN = jsonValue.GetString("tableBucketARN");
    m_tableBucketARNHasBeenSet = true;
  }
  if (jsonValue.ValueExists("configuration")) {
    Aws::Map<Aws::String, JsonView> configurationJsonMap = jsonValue.GetObject("configuration").GetAllObjects();
    for (auto& configurationItem : configurationJsonMap) {
      m_configuration[TableBucketMaintenanceTypeMapper::GetTableBucketMaintenanceTypeForName(configurationItem.first)] =
          configurationItem.second.AsObject();
    }
    m_configurationHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
