﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/schemas/model/RegistrySummary.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Schemas {
namespace Model {

RegistrySummary::RegistrySummary(JsonView jsonValue) { *this = jsonValue; }

RegistrySummary& RegistrySummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("RegistryArn")) {
    m_registryArn = jsonValue.GetString("RegistryArn");
    m_registryArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RegistryName")) {
    m_registryName = jsonValue.GetString("RegistryName");
    m_registryNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("tags")) {
    Aws::Map<Aws::String, JsonView> tagsJsonMap = jsonValue.GetObject("tags").GetAllObjects();
    for (auto& tagsItem : tagsJsonMap) {
      m_tags[tagsItem.first] = tagsItem.second.AsString();
    }
    m_tagsHasBeenSet = true;
  }
  return *this;
}

JsonValue RegistrySummary::Jsonize() const {
  JsonValue payload;

  if (m_registryArnHasBeenSet) {
    payload.WithString("RegistryArn", m_registryArn);
  }

  if (m_registryNameHasBeenSet) {
    payload.WithString("RegistryName", m_registryName);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("tags", std::move(tagsJsonMap));
  }

  return payload;
}

}  // namespace Model
}  // namespace Schemas
}  // namespace Aws
