﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/schemas/model/SchemaVersionSummary.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Schemas {
namespace Model {

SchemaVersionSummary::SchemaVersionSummary(JsonView jsonValue) { *this = jsonValue; }

SchemaVersionSummary& SchemaVersionSummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("SchemaArn")) {
    m_schemaArn = jsonValue.GetString("SchemaArn");
    m_schemaArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("SchemaName")) {
    m_schemaName = jsonValue.GetString("SchemaName");
    m_schemaNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("SchemaVersion")) {
    m_schemaVersion = jsonValue.GetString("SchemaVersion");
    m_schemaVersionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Type")) {
    m_type = TypeMapper::GetTypeForName(jsonValue.GetString("Type"));
    m_typeHasBeenSet = true;
  }
  return *this;
}

JsonValue SchemaVersionSummary::Jsonize() const {
  JsonValue payload;

  if (m_schemaArnHasBeenSet) {
    payload.WithString("SchemaArn", m_schemaArn);
  }

  if (m_schemaNameHasBeenSet) {
    payload.WithString("SchemaName", m_schemaName);
  }

  if (m_schemaVersionHasBeenSet) {
    payload.WithString("SchemaVersion", m_schemaVersion);
  }

  if (m_typeHasBeenSet) {
    payload.WithString("Type", TypeMapper::GetNameForType(m_type));
  }

  return payload;
}

}  // namespace Model
}  // namespace Schemas
}  // namespace Aws
