﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/sdb/model/CreateDomainRequest.h>

using namespace Aws::SimpleDB::Model;
using namespace Aws::Utils;

Aws::String CreateDomainRequest::SerializePayload() const {
  Aws::StringStream ss;
  ss << "Action=CreateDomain&";
  if (m_domainNameHasBeenSet) {
    ss << "DomainName=" << StringUtils::URLEncode(m_domainName.c_str()) << "&";
  }

  ss << "Version=2009-04-15";
  return ss.str();
}

void CreateDomainRequest::DumpBodyToUrl(Aws::Http::URI& uri) const { uri.SetQueryString(SerializePayload()); }
