﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/socialmessaging/model/ListWhatsAppTemplateLibraryRequest.h>

#include <utility>

using namespace Aws::SocialMessaging::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String ListWhatsAppTemplateLibraryRequest::SerializePayload() const {
  JsonValue payload;

  if (m_nextTokenHasBeenSet) {
    payload.WithString("nextToken", m_nextToken);
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("maxResults", m_maxResults);
  }

  if (m_filtersHasBeenSet) {
    JsonValue filtersJsonMap;
    for (auto& filtersItem : m_filters) {
      filtersJsonMap.WithString(filtersItem.first, filtersItem.second);
    }
    payload.WithObject("filters", std::move(filtersJsonMap));
  }

  return payload.View().WriteReadable();
}

void ListWhatsAppTemplateLibraryRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_idHasBeenSet) {
    ss << m_id;
    uri.AddQueryStringParameter("id", ss.str());
    ss.str("");
  }
}
