﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/socialmessaging/model/RegistrationStatus.h>

using namespace Aws::Utils;

namespace Aws {
namespace SocialMessaging {
namespace Model {
namespace RegistrationStatusMapper {

static const int COMPLETE_HASH = HashingUtils::HashString("COMPLETE");
static const int INCOMPLETE_HASH = HashingUtils::HashString("INCOMPLETE");

RegistrationStatus GetRegistrationStatusForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == COMPLETE_HASH) {
    return RegistrationStatus::COMPLETE;
  } else if (hashCode == INCOMPLETE_HASH) {
    return RegistrationStatus::INCOMPLETE;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<RegistrationStatus>(hashCode);
  }

  return RegistrationStatus::NOT_SET;
}

Aws::String GetNameForRegistrationStatus(RegistrationStatus enumValue) {
  switch (enumValue) {
    case RegistrationStatus::NOT_SET:
      return {};
    case RegistrationStatus::COMPLETE:
      return "COMPLETE";
    case RegistrationStatus::INCOMPLETE:
      return "INCOMPLETE";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace RegistrationStatusMapper
}  // namespace Model
}  // namespace SocialMessaging
}  // namespace Aws
