﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/sqs/model/GetQueueUrlResult.h>

#include <utility>

using namespace Aws::SQS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetQueueUrlResult::GetQueueUrlResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetQueueUrlResult& GetQueueUrlResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("QueueUrl")) {
    m_queueUrl = jsonValue.GetString("QueueUrl");
    m_queueUrlHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  const auto& responseMetadataIter = headers.find("x-amzn-requestid");
  if (responseMetadataIter != headers.end()) {
    m_responseMetadataHasBeenSet = true;
    // for backward compatibility for customers used to an old XML Client interface
    m_responseMetadata.SetRequestId(responseMetadataIter->second);
  }

  return *this;
}
