﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/ssm-sap/model/ListConfigurationCheckDefinitionsResult.h>

#include <utility>

using namespace Aws::SsmSap::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListConfigurationCheckDefinitionsResult::ListConfigurationCheckDefinitionsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListConfigurationCheckDefinitionsResult& ListConfigurationCheckDefinitionsResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("ConfigurationChecks")) {
    Aws::Utils::Array<JsonView> configurationChecksJsonList = jsonValue.GetArray("ConfigurationChecks");
    for (unsigned configurationChecksIndex = 0; configurationChecksIndex < configurationChecksJsonList.GetLength();
         ++configurationChecksIndex) {
      m_configurationChecks.push_back(configurationChecksJsonList[configurationChecksIndex].AsObject());
    }
    m_configurationChecksHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
