﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/ssm-sap/model/ListOperationEventsResult.h>

#include <utility>

using namespace Aws::SsmSap::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListOperationEventsResult::ListOperationEventsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListOperationEventsResult& ListOperationEventsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("OperationEvents")) {
    Aws::Utils::Array<JsonView> operationEventsJsonList = jsonValue.GetArray("OperationEvents");
    for (unsigned operationEventsIndex = 0; operationEventsIndex < operationEventsJsonList.GetLength(); ++operationEventsIndex) {
      m_operationEvents.push_back(operationEventsJsonList[operationEventsIndex].AsObject());
    }
    m_operationEventsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
