﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/ssm-sap/model/ListSubCheckResultsResult.h>

#include <utility>

using namespace Aws::SsmSap::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListSubCheckResultsResult::ListSubCheckResultsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListSubCheckResultsResult& ListSubCheckResultsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("SubCheckResults")) {
    Aws::Utils::Array<JsonView> subCheckResultsJsonList = jsonValue.GetArray("SubCheckResults");
    for (unsigned subCheckResultsIndex = 0; subCheckResultsIndex < subCheckResultsJsonList.GetLength(); ++subCheckResultsIndex) {
      m_subCheckResults.push_back(subCheckResultsJsonList[subCheckResultsIndex].AsObject());
    }
    m_subCheckResultsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
