﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/states/model/DeleteStateMachineRequest.h>

#include <utility>

using namespace Aws::SFN::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteStateMachineRequest::SerializePayload() const {
  JsonValue payload;

  if (m_stateMachineArnHasBeenSet) {
    payload.WithString("stateMachineArn", m_stateMachineArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteStateMachineRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSStepFunctions.DeleteStateMachine"));
  return headers;
}
