﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/states/model/DescribeStateMachineRequest.h>

#include <utility>

using namespace Aws::SFN::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeStateMachineRequest::SerializePayload() const {
  JsonValue payload;

  if (m_stateMachineArnHasBeenSet) {
    payload.WithString("stateMachineArn", m_stateMachineArn);
  }

  if (m_includedDataHasBeenSet) {
    payload.WithString("includedData", IncludedDataMapper::GetNameForIncludedData(m_includedData));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeStateMachineRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSStepFunctions.DescribeStateMachine"));
  return headers;
}
