﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/states/model/MapRunStartedEventDetails.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace SFN {
namespace Model {

MapRunStartedEventDetails::MapRunStartedEventDetails(JsonView jsonValue) { *this = jsonValue; }

MapRunStartedEventDetails& MapRunStartedEventDetails::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("mapRunArn")) {
    m_mapRunArn = jsonValue.GetString("mapRunArn");
    m_mapRunArnHasBeenSet = true;
  }
  return *this;
}

JsonValue MapRunStartedEventDetails::Jsonize() const {
  JsonValue payload;

  if (m_mapRunArnHasBeenSet) {
    payload.WithString("mapRunArn", m_mapRunArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace SFN
}  // namespace Aws
