﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/states/model/SendTaskFailureRequest.h>

#include <utility>

using namespace Aws::SFN::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String SendTaskFailureRequest::SerializePayload() const {
  JsonValue payload;

  if (m_taskTokenHasBeenSet) {
    payload.WithString("taskToken", m_taskToken);
  }

  if (m_errorHasBeenSet) {
    payload.WithString("error", m_error);
  }

  if (m_causeHasBeenSet) {
    payload.WithString("cause", m_cause);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection SendTaskFailureRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSStepFunctions.SendTaskFailure"));
  return headers;
}
