﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/states/model/ValidateStateMachineDefinitionRequest.h>

#include <utility>

using namespace Aws::SFN::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ValidateStateMachineDefinitionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_definitionHasBeenSet) {
    payload.WithString("definition", m_definition);
  }

  if (m_typeHasBeenSet) {
    payload.WithString("type", StateMachineTypeMapper::GetNameForStateMachineType(m_type));
  }

  if (m_severityHasBeenSet) {
    payload.WithString("severity",
                       ValidateStateMachineDefinitionSeverityMapper::GetNameForValidateStateMachineDefinitionSeverity(m_severity));
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("maxResults", m_maxResults);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ValidateStateMachineDefinitionRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSStepFunctions.ValidateStateMachineDefinition"));
  return headers;
}
