﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/storagegateway/model/CreateStorediSCSIVolumeResult.h>

#include <utility>

using namespace Aws::StorageGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreateStorediSCSIVolumeResult::CreateStorediSCSIVolumeResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

CreateStorediSCSIVolumeResult& CreateStorediSCSIVolumeResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("VolumeARN")) {
    m_volumeARN = jsonValue.GetString("VolumeARN");
    m_volumeARNHasBeenSet = true;
  }
  if (jsonValue.ValueExists("VolumeSizeInBytes")) {
    m_volumeSizeInBytes = jsonValue.GetInt64("VolumeSizeInBytes");
    m_volumeSizeInBytesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("TargetARN")) {
    m_targetARN = jsonValue.GetString("TargetARN");
    m_targetARNHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
